within ;
model DiscBrakeTestBench
  DiscBrake discBrake(max_force=50)
    annotation (Placement(transformation(extent={{22,22},{42,42}})));
  Modelica.Blocks.Sources.Ramp ramp(height=100, duration=10)
    annotation (Placement(transformation(extent={{-82,28},{-62,48}})));
  Modelica.Mechanics.Rotational.Sources.Torque torque
    annotation (Placement(transformation(extent={{-38,26},{-18,46}})));
  Modelica.Mechanics.Rotational.Components.Damper damper(d=0.7)
    annotation (Placement(transformation(extent={{50,22},{70,42}})));
  Modelica.Mechanics.Rotational.Components.Fixed fixed
    annotation (Placement(transformation(extent={{60,-28},{80,-8}})));
  Modelica.Blocks.Sources.TimeTable timeTable1(table=[0,0; 20,0; 21,1; 25,1; 26,
        0; 200,0])
    annotation (Placement(transformation(extent={{-18,68},{2,88}})));
  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=2)
    annotation (Placement(transformation(extent={{-8,24},{12,44}})));
equation
  connect(ramp.y, torque.tau) annotation (Line(
      points={{-61,38},{-50,38},{-50,36},{-40,36}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(discBrake.flange_b, damper.flange_a) annotation (Line(
      points={{39.4,32},{50,32}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(damper.flange_b, fixed.flange) annotation (Line(
      points={{70,32},{70,-18}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(timeTable1.y, discBrake.u) annotation (Line(
      points={{3,78},{32,78},{32,39.6},{31.4,39.6}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(torque.flange, inertia.flange_a) annotation (Line(
      points={{-18,36},{-12,36},{-12,34},{-8,34}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia.flange_b, discBrake.flange_a) annotation (Line(
      points={{12,34},{18,34},{18,32},{23,32}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")), Diagram(graphics));
end DiscBrakeTestBench;
